

(defmeth lsmt-plot-proto :reg-control-panel ()
  (let* ((splot (send self :spreadplot-supervisor))
         (container (send splot :container))
         (plot self)
         (av (send splot :added-var-plot))
         (robreg (send splot :robust-reg-plot))
         (res (send splot :residual-plot2))
         (linreg (send splot :lin-reg-plot))
         (raw (send self :raw))
         (trans (send self :trans))
         (fit (send self :fit-trans))
         (add-bayes-lines? nil)
         (mod (send splot :model))
         (model (send mod :morals-model))
         (current-method (send mod :method))
         (real-method (send mod :control-panel-method))
         (robmod? (equal current-method "Robust"))
         (y (send model :y))
         (labels (send mod :labels))
         (datamat (send model :x))
         (nobs (send mod :nobs))
         (num (iseq (select (array-dimensions datamat) 1)))
         (iv (select (send mod :variables) (send mod :iv)))
         (dv2 (select (send mod :variables) (send mod :dv)))
         (dv (if (listp dv2) (select dv2 0) dv2))
         (text0 (send text-item-proto :new 
                      (format nil "WINDOWS:_________________________________")))
         (vis-window (send toggle-item-proto :new "Show Visualization"
                             :value t
                             :action #'(lambda () (send self :reveal-spreadplot))))
         (iter-window (send toggle-item-proto :new "Show Iterations"
                            :value nil
                            :action #'(lambda () 
                                        (send splot :reveal-iter-window
                                              iter-window)
                                        )))
         (reg-report  (send toggle-item-proto :new "Show Report"
                            :value nil
                            :action #'(lambda () 
                                        (send self :do-reg-report splot))))
         (text1 (send text-item-proto :new 
                      (format nil "VARIABLES:_________________________________")))
         (reg-type-plot (send choice-item-proto :new 
                             (list "Fit & Regression Plot"                                  
                                   "Added Variable Plot")
                             :value 0 
                             :action #'(lambda () 
                                         (send self :switch-reg-plots mod))))
         

         (space (send text-item-proto :new (format nil "A.V.~%Plot~%For:")))
         (var-toggle (send choice-item-proto :new iv :value (send av :x)
                           :action #'(lambda () (send av :do-the-var-selected))))
         (plot-toggle (send choice-item-proto :new (combine dv iv)
                            :action #'(lambda () 
                                        (send self :switch-fit/av-plots))))
         (text2 (send text-item-proto :new 
                      (format nil "OPTIONS:_________________________________")))
         (reg-line    (send toggle-item-proto :new "Regression Line"
                            :value (send self :add-regline?)
                            :action #'(lambda ()
                                        (send self :do-regline)
                                        )))
         (resid-lines (send toggle-item-proto :new "Residual Lines"
                            :value (send self :add-regresiduals?)
                            :action #'(lambda () 
                                        (send self :do-residlines))))
         (reg-oval    (send toggle-item-proto :new "Regression Oval"
                            :value (send self :add-regcontour?)
                            :action #'(lambda ()
                                        (send self :do-regcontour))))
         (bayes-lines (send toggle-item-proto :new "Confidence Intervals"
                           :value add-bayes-lines?
                           :action #'(lambda ()
                                       (send res :do-bayes-lines))))
         (reg-lsmt (send toggle-item-proto :new "Monotone Linearizer"
                         :value (send self :add-lsmt?)
                         :action #'(lambda () 
                                     (send self :switch-add-lsmt?)
                                     )))
         
         (text3 (send text-item-proto :new 
                      (format nil "FIT METHODS:_________________________________")))
         
         (non-ols-type (send choice-item-proto :new
                             (select
                              (list "Ordinary Regression" 
                                    "Monotonic Regression" 
                                    "Robust Regression")
                              (list 0 real-method))
                             :value 1 
                             :action #'(lambda () 
                                         (send self :do-another-visualization
                                               current-method real-method splot))))
         ;reg-oval removed even tho works right
         ;because interpretation hard to defend

         (text4 (send text-item-proto :new 
                      (format nil "DEMONSTRATIONS:_________________________________")))

       
         (influ-demo (send toggle-item-proto :new "Influence Points"
                         :action #'(lambda () 
                                     (send av :do-influ-demo)
                                     )))

         (range-demo (send toggle-item-proto :new "Restricted Range"
                         :action #'(lambda () 
                                     (send av :do-range-demo)
                                     )))
         (influ-plot)
         (range-plot)
         (dialog (send dialog-proto :new
                       (if (> real-method 0)
                           (list text1 plot-toggle
                                 text2 reg-line resid-lines reg-lsmt bayes-lines
                                                ;iter-window  reg-oval
                                 text3 non-ols-type
                                 text4 influ-demo range-demo
                                 )
                           (list text1 plot-toggle
                                 text2 reg-line resid-lines reg-lsmt bayes-lines
                                 text4 influ-demo range-demo
                                 )
                           )
                       :frame-location '(2000 2000)
                       :show nil))
         )
    (setf *cntl-panl-iter-method* non-ols-type)
    (defmeth av :do-influ-demo ()
      (let ((plot-type (send plot-toggle :value))
            (dialog-toggle-item 'influ-demo)
            (x) (y) (x-name) (y-name))
        (cond
          ((= plot-type 0)
           (setf x (send plot :point-coordinate 0 (iseq nobs)))
           (setf y (send plot :point-coordinate 1 (iseq nobs)))
           (setf x-name (send plot :variable-label 0))
           (setf y-name (send plot :variable-label 1)))
          (t
           (setf x (send av :point-coordinate 0 (iseq nobs)))
           (setf y (send av :point-coordinate 1 (iseq nobs)))
           (setf x-name (send av :variable-label 0))
           (setf y-name (send av :variable-label 1))))
        (cond 
          ((send influ-demo :value) ;(send dialog-toggle-item :value)
           (setf influ-plot 
                  (regression-effects-plot x y #'influence-effects-plot 1
                                           :legend1 "Itertation History of"
                                           :legend2 "Influential and Outlying Points"
                                            :variable-labels (list x-name y-name))
                 )
           (unless (send container :has-slot 'influ-cntlpanl-item-objid)
                   (send container :add-slot 'influ-cntlpanl-item-objid))
           (send container :slot-value 'influ-cntlpanl-item-objid influ-demo)
           (send av :add-subordinate influ-plot)
           (defmeth influ-plot :close () 
             (send influ-demo :value nil) 
             (call-next-method))
           )
          (t
           (send influ-plot :close)
           (setf influ-plot nil)
           )) 
        ))

    (defmeth av :do-range-demo ()
      (let ((plot-type (send plot-toggle :value))
            (x) (y) (x-name) (y-name))
        (cond
          ((= plot-type 0)
           (setf x (send plot :point-coordinate 0 (iseq nobs)))
           (setf y (send plot :point-coordinate 1 (iseq nobs)))
           (setf x-name (send plot :variable-label 0))
           (setf y-name (send plot :variable-label 1)))
          (t
           (setf x (send av :point-coordinate 0 (iseq nobs)))
           (setf y (send av :point-coordinate 1 (iseq nobs)))
           (setf x-name (send av :variable-label 0))
           (setf y-name (send av :variable-label 1))))
        (cond 
          ((send range-demo :value)
           (setf range-plot
                 (regression-effects-plot x y #'restriction-of-range-plot 0
                                          :legend1 "Demonstrates Effects On Regression Equation of"
                                          :legend2 "Restriction of X-Variable Range"
                                          :variable-labels (list x-name y-name)))
           (unless (send container :has-slot 'range-cntlpanl-item-objid)
                   (send container :add-slot 'range-cntlpanl-item-objid))
           (send container :slot-value 'range-cntlpanl-item-objid range-demo)
           (send av :add-subordinate range-plot)
           (defmeth range-plot :close () 
             (send range-demo :value nil) 
             (call-next-method))
           )
          (t 
           (send range-plot :close)
           (setf range-plot :nil)
           ))
        ))



    (send dialog :add-slot 'vis-dialog-item vis-window)
    (send dialog :add-slot 'iter-dialog-item iter-window)
    (defmeth dialog :vis-dialog-item (&optional (logical nil set))
      (when set (setf (slot-value 'vis-dialog-item) logical)) 
      (slot-value 'vis-dialog-item))
    (defmeth dialog :iter-dialog-item (&optional (logical nil set)) 
      (when set (setf (slot-value 'iter-dialog-item) logical)) 
      (slot-value 'iter-dialog-item))
    (setf *reg-control-panel* dialog)
    (send dialog :title "Control Panel")


    (defmeth lsmt-plot-proto :switch-linearizer ()
      (send self :switch-add-lsmt?)
      (send reg-lsmt :value (send self :add-lsmt?)))

    (defmeth lsmt-plot-proto :prepare-for-lsmt-iter ()
      (unless (= (send plot-toggle :value) 0)
                 (send self :switch-fit/av-plots 0))
      (unless (= (send non-ols-type :value) 1)
              (send non-ols-type :value 1)
              (send self :do-another-visualization current-method)))  

    (defmeth lsmt-plot-proto :reveal-spreadplot ()
      (send vis-window :value t)
      (send container :front-window)
      (pause 20)
      (send vis-window :value nil))

    (defmeth lsmt-plot-proto :do-regline (&optional dont-do-residlines)
      (when (and (send self :add-regresiduals?) (not dont-do-residlines))
              (send resid-lines :value nil)
              (send self :do-residlines t))
      (send self :switch-add-regline)
      (send av   :switch-add-regline)
      (when robmod? (send robreg :switch-add-regline))
      (send reg-line :value (send self :add-regline?)))

;this method for joint toggle of bayes from regresids when do-bayes-too t

    (defmeth lsmt-plot-proto :do-residlines (&optional do-bayes-too)
      (send self :switch-add-regresiduals)
      (send av :switch-add-regresiduals)
      (when robmod? (send robreg :switch-add-regresiduals))
      (send reg-line :value (send self :add-regline?))
      (when do-bayes-too (send res :do-bayes-lines)))
      
;this method for separate toggle of bayes from regresids

    (defmeth residual-plot-proto :do-bayes-lines ()
      (setf add-bayes-lines? (not add-bayes-lines?))
      (send bayes-lines :value add-bayes-lines?)
      (send splot :confidence-intervals add-bayes-lines?)
      (case (send non-ols-type :value)
        (0 (send splot :get-residuals res 
                 (if add-bayes-lines? 1 0)))
        (1 (send splot :get-residuals res
                 (if add-bayes-lines? 5 4)))))
    
    (defmeth lsmt-plot-proto :do-regcontour ()
      (send self :switch-add-regcontour)
      (send av :switch-add-regcontour)
      (when robmod? (send robreg :switch-add-regcontour))
      (send reg-oval :value (send self :add-regcontour?)))

    (defmeth lsmt-plot-proto :switch-add-lsmt? ()    
      (cond 
        ((< (send non-ols-type :value) 2)
         (send self :switch-add-lsmt)
         (send av :switch-add-lsmt)
         (when robmod? (send robreg :switch-add-lsmt))
         )
        (t
         (send self :add-lsmt? nil)))
      (send reg-lsmt :value (send self :add-lsmt?)))


    (defmeth lsmt-plot-proto :do-another-visualization 
                      (method &optional real-method splotobj)
      (send self :switch-visualizations mod method (send non-ols-type :value)
            reg-line resid-lines reg-oval add-bayes-lines? reg-lsmt)
      (when real-method
            (mapcar #'(lambda (plot)
                        (when (and plot (send plot :has-slot 'legend1))
                              (case (send non-ols-type :value)
                                (0 (send plot :legend1 "Least Squares Regression"))
                                (1 (send plot :legend1
                                       (format nil "~a Regression" method))))
                              (send plot :redraw)))
                    (combine (send splotobj :plot-matrix)))
           	))
      
    (defmeth lsmt-plot-proto :do-reg-report (splot)
      (send (send splot :model) :report)
      (send reg-report :value nil))
    
    (defmeth lsmt-plot-proto :switch-fit/av-plots (&optional plot-num)
      (when plot-num (send plot-toggle :value plot-num))
      (cond 
        ((= (send plot-toggle :value) 0)(print self)
         (send self :front-window))
        (t (print av)
         (send av :update-added-var-plot (1- (send plot-toggle :value))
            datamat y dv nobs num mod
            (send reg-line :value) 
            (send resid-lines :value) 
            (send reg-lsmt :value))
         (send av :front-window))))

    (defmeth av :do-the-var-selected ()(one-button-dialog "Doing the Var Selected")
      (send av :update-added-var-plot (send var-toggle :value)
            datamat y dv nobs num mod
            (send reg-line :value) 
            (send resid-lines :value) 
            (send reg-lsmt :value))
      )

    (defmeth lsmt-plot-proto :switch-reg-plots (model)
      (case (send reg-type-plot :value)
        (0 (send self :front-window))
        (1 (send av :do-the-var-selected)
           (send av :front-window)
           )))
    dialog)) 
    

    
(defmeth lsmt-plot-proto :switch-visualizations 
  (model method type reg-line resid-lines reg-oval add-bayes-lines? reg-lsmt)
  (case type
    (0 (cond                                            ;want to switch to OLS
         ((equal method "Monotonic") 
          (send self :show-linear add-bayes-lines?))
         ((equal method "Robust")                       ;from Robust
          (send self :show-linear add-bayes-lines?)
          )))
    (1 (cond                                            ;want to switch to MLS
         ((equal method "Monotonic")
         ; (send self :add-lsmt? nil)
         ; (send reg-lsmt :value nil)
          (let* ((splot (send self :spreadplot-supervisor))
                 (ic (send splot :iter-container)))
            (send ic :show-window)
            (send ic :front-window)
            )
          (send self :show-linearized add-bayes-lines?))
         ((equal method "Robust")                       ;from Robust
          )))
    (2 (cond                                            ;want to switch to Robust
         ((equal method "Monotonic")
          (send rob :iter8))
         ((equal method "Linear")
          (send rob :iter8)))))
  )
    
 
    

(defmeth lsmt-plot-proto :switch-button-action ()
  (let* ((splot (send self :spreadplot-supervisor))
         (av (send splot :added-var-plot))
         )
    (send av :front-window)))



(defmeth lsmt-plot-proto :adjust-to-data (&key (draw t))
  (call-next-method)
  (let* ((a (combine (send self :range 0) (send self :range 1))))
    (send self :range 0 (min a) (max a))
    (send self :range 1 (min a) (max a))))
         

(defmeth lsmt-plot-proto :close ()
  (send (send self :spreadplot-supervisor) :close-dialog self))


